<?php
/* --------------------------------------------------------------
 AuthenticationMiddlewareServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Api\Application\ServiceProviders;

use Gambio\Api\Application\Auth\BasicRequestAuthenticator;
use Gambio\Api\Application\Auth\BearerRequestAuthenticator;
use Gambio\Api\Application\Auth\Interfaces\WebRequestAuthenticationService;
use Gambio\Api\Application\Auth\RequestAuthenticationService;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Auth\JsonWebTokenAuthenticator;
use Gambio\Core\Auth\UserAuthenticator;
use Gambio\Core\Permission\PermissionRepository;

/**
 * Class AuthenticationMiddlewareServiceProvider
 * @package Gambio\Api\Application\ServiceProvider
 */
class RequestAuthenticationServiceServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            WebRequestAuthenticationService::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(BasicRequestAuthenticator::class)->addArgument(UserAuthenticator::class);
        $this->application->add(BearerRequestAuthenticator::class)->addArgument(JsonWebTokenAuthenticator::class);
        
        $this->application->add(WebRequestAuthenticationService::class, RequestAuthenticationService::class)
            ->addArgument(PermissionRepository::class)
            ->addArgument(BasicRequestAuthenticator::class)
            ->addArgument(BearerRequestAuthenticator::class);
    }
}